#pragma warning( disable : 4996 ) // Allow non _s func's

#ifndef SOMARRAY_H
#define SOMARRAY_H

#include <Windows.h>
#include <stdio.h>
#include "dblreader.h"

#define SOM_HEADER			0xDEADBEEF
//#define SOM_NUMMESHES		19
#define SOM_NUMSUBMESHES	2
#define SOM_OFFSINDICES		16
#define SOM_NUMINDICES		17
#define SOM_VERTOFFS		18

#define MESH_MESHID			2
#define MESH_STRTINDICE		5
#define MESH_NUMINDICES		8

#define VERT_OFFSET			0
#define VERT_NUMVERTS		1
#define VERT_STRIDE			2
#define VERT_SIZE			3

typedef struct sVertex_t {
	float x, y, z;
} sVertex_s;

typedef struct sIndice_t {
	INT16 x, y, z;
} sIndice_s;

// Mesh
typedef struct sMesh_t {
	sVertex_s* vertexes; // Array of vertexes that this mesh comprises of
	UINT16* indices; // Indices telling us how to order the vertexes?
	sVertex_s* normals; // UNUSED: Have to calculate them somehow?
	sVertex_s uv; // UNDONE
	INT* meshData; // Mesh-data array, see MESH_ defines
	INT* vertData; // Vert-data array, see VERT_ defines
} sMesh_s;

// SOM object, contains submeshes & some info
typedef struct sSOMObj_t {
	sMesh_s* submeshes; // Sub-meshes
	INT somHeader[20]; // Header for this SOM object, see SOM_ defines
} sSOMObj_s;

// Array of SOM's
typedef struct somArray_t {
	sSOMObj_s* meshes; // SOM objects
	INT* somOffsets; // Offsets to get the data for SOM objects from
	INT nummeshes; // Total number of SOM objects inside this array
	INT iSize; // UNUSED: Chunk size
} somArray_s;

// Load a Som Array chunk into memory
somArray_s* ReadSomArrayChunk( char* fname, dbl_chunk_header_s* pChunkHeader,
							   System::Windows::Forms::RichTextBox^ logbox, INT iAdditionalOffset = 0 );

sVertex_s CalculateNormal( sVertex_s* vert );

// Create an OBJ file from the given Som Array
BOOL ConstructOBJ( char* obj, somArray_s* pSomArray, char** fnames, INT iMesh = -1 );

#endif